/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.fru;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.LocalizablePanelValue;
import com.ibm.hwmca.xfw.panel.LocalizableTimePanelValue;
import com.ibm.hwmca.xfw.panel.NonLocalizablePanelValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class CommonPaFru
implements PersistentData,
XMLEncodeable {
    private String _name = "";
    private ArrayList _locationList = new ArrayList();
    private String _partNumber = "";
    private String _serialNumber = "";
    private String _percent = "";
    private String _ECLevel = "";
    private String _id = "";
    private String _description = "";
    private boolean _isReplaced = false;
    private String _previousPartNumber = "";
    private String _previousSerialNumber = "";
    private long _replacedTime = 0L;
    private PASystem _enclosureSystem = new PASystem();
    private static final long serialVersionUID = 1L;

    public CommonPaFru() {
    }

    public CommonPaFru(String name, String location, String partNumber, String serialNumber, String percent, String ECLevel) {
        this._name = name;
        this._locationList.add(location);
        this._partNumber = partNumber;
        this._serialNumber = serialNumber;
        this._percent = percent;
        this._ECLevel = ECLevel;
    }

    public void toXML(StringBuffer sb) {
        sb.append("<FRU class=\"" + this.getClass().getName() + "\"");
        sb.append(" name=\"" + this._name + "\"");
        sb.append(" sernum=\"" + this._serialNumber + "\"");
        sb.append(" partnum=\"" + this._partNumber + "\"");
        sb.append(" eclevel=\"" + this._ECLevel + "\"");
        sb.append(" percent=\"" + this._percent + "\"");
        sb.append("/>");
    }

    public void fromXML(Node fruNode) {
        if (fruNode.hasAttributes()) {
            this.setName(XMLHelper.getAttributeValue(fruNode, "name"));
            this.setName(XMLHelper.getAttributeValue(fruNode, "sernum"));
            this.setName(XMLHelper.getAttributeValue(fruNode, "partnum"));
            this.setName(XMLHelper.getAttributeValue(fruNode, "eclevel"));
            this.setName(XMLHelper.getAttributeValue(fruNode, "percent"));
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ArrayList getLocationList() {
        return this._locationList;
    }

    public void addLocation(String location) {
        this._locationList.add(location);
    }

    public String getLocation() {
        if (this._locationList.isEmpty()) {
            return null;
        }
        return (String)this._locationList.get(0);
    }

    public void setLocation(String location) {
        this.addLocation(location);
    }

    public String getPartNumber() {
        return this._partNumber;
    }

    public void setPartNumber(String partNumber) {
        this._partNumber = partNumber;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this._serialNumber = serialNumber;
    }

    public String getPercent() {
        return this._percent;
    }

    public void setPercent(String percent) {
        this._percent = percent;
    }

    public String getECLevel() {
        return this._ECLevel;
    }

    public void setECLevel(String ECLevel) {
        this._ECLevel = ECLevel;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setReplacedPrior(boolean replaced) {
        this._isReplaced = replaced;
    }

    public boolean isReplacedPrior() {
        return this._isReplaced;
    }

    public String getPreviousPartNumber() {
        return this._previousPartNumber;
    }

    public void setPreviousPartNumber(String partNumber) {
        this._previousPartNumber = partNumber;
    }

    public String getPreviousSerialNumber() {
        return this._previousSerialNumber;
    }

    public void setPreviousSerialNumber(String serialNumber) {
        this._previousSerialNumber = serialNumber;
    }

    public void setReplacedTimeStamp(long timestamp) {
        this._replacedTime = timestamp;
    }

    public long getReplacedTimeStamp() {
        return this._replacedTime;
    }

    public void setEnclosureSystem(PASystem enclosureSystem) {
        this._enclosureSystem = enclosureSystem;
    }

    public PASystem getEnclosureSystem() {
        return this._enclosureSystem;
    }

    public void setEnclosureType(String type) {
        this._enclosureSystem.setMachineType(type);
    }

    public void setEnclosureModel(String model) {
        this._enclosureSystem.setMachineModel(model);
    }

    public void setEnclosureSerial(String serial) {
        this._enclosureSystem.setMachineSerial(serial);
    }

    public String getEnclosureType() {
        if (this._enclosureSystem != null) {
            return this._enclosureSystem.getMachineType();
        }
        return "";
    }

    public String getEnclosureModel() {
        if (this._enclosureSystem != null) {
            return this._enclosureSystem.getMachineModel();
        }
        return "";
    }

    public String getEnclosureSerial() {
        if (this._enclosureSystem != null) {
            return this._enclosureSystem.getMachineSerial();
        }
        return "";
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String toString() {
        String fruString = new String();
        fruString = fruString.concat("name=" + this._name);
        fruString = fruString.concat("\nlocation=");
        int i = 0;
        while (i < this._locationList.size()) {
            if (i > 0) {
                fruString = fruString.concat(",");
            }
            fruString = fruString.concat((String)this._locationList.get(i));
            ++i;
        }
        fruString = fruString.concat("\npartNumber=" + this._partNumber);
        fruString = fruString.concat("\nserialNumber=" + this._serialNumber);
        fruString = fruString.concat("\npercent=" + this._percent);
        fruString = fruString.concat("\nECLevel=" + this._ECLevel);
        fruString = fruString.concat("\nid=" + this._id);
        fruString = fruString.concat("\npreviousPartNumber=" + this._previousPartNumber);
        fruString = fruString.concat("\npreviousSerialNumber=" + this._previousSerialNumber);
        fruString = fruString.concat("\nreplacedTime=" + this._replacedTime);
        fruString = fruString.concat("\ndescription=" + this._description);
        fruString = this._enclosureSystem != null ? fruString.concat("\nenclosure System=" + this._enclosureSystem.getMTMS()) : fruString.concat("\nenclosure System=not set");
        return fruString;
    }

    public List getPanelData() {
        ArrayList<CaptionValuePairing> panelList = new ArrayList<CaptionValuePairing>();
        CaptionValuePairing cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7600"), new NonLocalizablePanelValue(this._partNumber));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7671"), new NonLocalizablePanelValue(this._description));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        StringBuffer locationSB = new StringBuffer("");
        int i = 0;
        while (i < this._locationList.size()) {
            if (i > 0) {
                locationSB.append(",");
            }
            locationSB.append((String)this._locationList.get(i));
            ++i;
        }
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7601"), new NonLocalizablePanelValue(locationSB.toString()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        if (this.isReplacedPrior()) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7608"), new LocalizablePanelValue("com/ibm/hwmca/base/res/message", "XPA7610"));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7609"), new LocalizableTimePanelValue(this._replacedTime));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        } else {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7608"), new LocalizablePanelValue("com/ibm/hwmca/base/res/message", "XPA7611"));
        }
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7670"), new NonLocalizablePanelValue(this._serialNumber));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        return panelList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonPaFru) {
            CommonPaFru referenceFru = (CommonPaFru)obj;
            if (this.getLocationList().equals(referenceFru.getLocationList())) {
                if (this.getSerialNumber().equals(referenceFru.getSerialNumber())) {
                    return this.getPartNumber().equals(referenceFru.getPartNumber());
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

